#ifndef LIBWCCL_OPS_ACTIONEXECCONTEXT_H
#define LIBWCCL_OPS_ACTIONEXECCONTEXT_H

#include <boost/noncopyable.hpp>
#include <libwccl/variables.h>
#include <libwccl/sentencecontext.h>

namespace Wccl {

/**
 * Class holding execution context of an action
 * i.e. state that the action should operate on.
 */
class ActionExecContext : boost::noncopyable {
public:
	ActionExecContext(
			SentenceContext& sentence_context,
			const boost::shared_ptr<Variables>& vars)
		: sentence_context_(sentence_context), vars_(vars)
	{
	}

	/**
	 * @returns Context of a sentence the action is executed on.
	 */
	SentenceContext& sentence_context() const {
		return sentence_context_;
	}

	/**
	 * @returns Pointer to variables the operator should operate with.
	 * @note Variables should be accesible to modifications, but overall
	 * object should not get replaced, hence the const pointer.
	 */
	const boost::shared_ptr<Variables>& variables() const {
		return vars_;
	}

private:
	SentenceContext& sentence_context_;
	const boost::shared_ptr<Variables> vars_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_ACTIONEXECCONTEXT_H
