#include <libwccl/ops/match/conditions/optionalmatch.h>
#include <libwccl/values/matchvector.h>
#include <sstream>

namespace Wccl {

OptionalMatch::OptionalMatch(const boost::shared_ptr<ConjConditions>& conditions)
	: _conditions(conditions)
{
	BOOST_ASSERT(_conditions);
}

MatchResult OptionalMatch::apply(const ActionExecContext& context) const
{
	int orig_pos = context.sentence_context().get_position();
	MatchResult res = _conditions->apply(context);
	if (res.matched()) {
		return res;
	}
	context.sentence_context().set_position(orig_pos);
	return MatchResult(boost::make_shared<Match>());
}

std::string OptionalMatch::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ostream;
	ostream << name() << _conditions->to_string(tagset);
	return ostream.str();
}

std::ostream& OptionalMatch::write_to(std::ostream& ostream) const
{
	return ostream << name() << *_conditions;
}

} /* end ns Wccl */
