#include <cstdlib>

#include <libwccl/values/tset.h>

#include <libwccl/parser/Parser.h>
#include <libwccl/parser/ANTLRParserResult.h>

// ----------------------------------------------------------------------------

/**
 * @desc It's simple command line tester for testing tagset operators
 */
int main()
{
	std::string str_in;
	Corpus2::Tagset tagset;
	Parser parser(tagset);

	boost::shared_ptr<const Wccl::TSet> retVal;
	boost::shared_ptr<ANTLRParserResult<Wccl::TSet> > retOp;
	boost::shared_ptr<Corpus2::Sentence> sentence;
	Wccl::SentenceContext sc(sentence);

	if (system("clear")) {
		//
	}

	std::cerr << "Simple command line tester for testing bool operators"
						<< std::endl;

	while (1) {
		std::cerr << "Enter a bool operator expression: ";

		getline(std::cin, str_in);

		if (str_in == "clear" || str_in == "cls") {
			if (system("clear")) {
				//
			}
		}
		else if (str_in == "exit" || str_in == "quit") {
			break;
		}
		else {
			try {
				retOp = parser.parseSymSetOperator(str_in);

				if (retOp.get()) {
					Wccl::FunExecContext cx(sc, retOp->variables);

					if ((retVal = retOp->op->apply(cx)).get()) {
						std::cerr << "Parsed expression: " << retVal->to_raw_string()
											<< std::endl;
					}
					else {
						std::cerr << "Problem while parsing -- "
											<< "haven't got StrSet object in boost::shared_ptr!"
											<< std::endl;
					}
				}
				else {
					std::cerr << "Problem while parsing -- "
										<< "haven't got Function<Wccl::StrSet> object in "
										<< "boost::shared_ptr!" << std::endl;
				}
			}
			catch (antlr::MismatchedTokenException &e) {
				std::cerr << e.getMessage() << std::endl;
			}
			catch (...) {
				std::cerr << "[N] Syntax error!" << std::endl;
			}
		}
	}

  return 0;
}

