#include <libwccl/ops/matchrulesequence.h>
#include <libpwrutils/foreach.h>

#include <boost/shared_ptr.hpp>

namespace Wccl {
namespace Matching {

void MatchRuleSequence::apply_all(
		const boost::shared_ptr<Corpus2::AnnotatedSentence>& sentence)
{
	if(!sentence || sentence->empty()) {
		throw InvalidArgument(
				"sentence",
				"Received an empty sentence.");
	}
	foreach (MatchRule& rule, *this) {
		rule.apply(sentence);
	}
}

void MatchRuleSequence::apply_all_sentence_wrapper(
		const boost::shared_ptr<Corpus2::Sentence>& sentence)
{
	boost::shared_ptr<Corpus2::AnnotatedSentence> as;
	as = boost::dynamic_pointer_cast<Corpus2::AnnotatedSentence>(sentence);
	if (!as) {
		throw InvalidArgument(
				"sentence",
				"Did not get an AnnotatedSentence from reader, 'ann' option broken?");
	}
	apply_all(as);
}

std::string MatchRuleSequence::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream os;
	os << "match_rules(\n";
	for (size_t i = 0; i < size(); ++i) {
		if (i != 0) {
			os << ";\n";
		}
		os << at(i).to_string(tagset);
	}
	os << ")";
	return os.str();
}

std::ostream& MatchRuleSequence::write_to(std::ostream &os) const
{
	os << "match_rules(\n";
	for (size_t i = 0; i < size(); ++i) {
		if (i != 0) {
			os << ";\n";
		}
		os << at(i);
	}
	os << ")";
	return os;
}

} /* end ns Matching */
} /* end ns Wccl */

