#ifndef LIBWCCL_OPS_MATCH_CONDITIONS_ONEOF_H
#define LIBWCCL_OPS_MATCH_CONDITIONS_ONEOF_H

#include <libwccl/ops/match/conditions/conjconditions.h>

namespace Wccl {
namespace Matching {

/**
 * Class for "oneof" condition of match
 */
class OneOf : public MatchCondition
{
public:
	OneOf(const boost::shared_ptr<std::vector<boost::shared_ptr<ConjConditions> > >& variants);

	/**
	 * @returns Name of the condition.
	 */
	std::string name() const {
		return "oneof";
	}
	/**
	 * Applies the condition to the given execution context.
	 * Inner match variants are executed one by one until a "true" one is found.
	 * Once a "true" variant is found, it is returned with "true" MatchResult.
	 * If there was no "true" match variant, "false" is returned instead.
	 * If a match is found, the current sentence Position is increased
	 * as to point one token after all the matched tokens, otherwise
	 * it stays unchanged.
	 */
	MatchResult apply(const ActionExecContext& context) const;

	/**
	 * @returns String representation of the MatchCondition
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

protected:
	/**
	 * Writes string representation of the MatchCondition to
	 * an output stream.
	 * @returns Stream written to.
	 * @note May be incomplete and/or containt internal info.
	 */
	std::ostream& write_to(std::ostream& ostream) const;
private:
	const boost::shared_ptr<std::vector<boost::shared_ptr<ConjConditions> > > _variants;
};
} /* end ns Matching */
} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_CONDITIONS_ONEOF_H
