#ifndef LIBWCCL_OPS_FUNEXECCONTEXT_H
#define LIBWCCL_OPS_FUNEXECCONTEXT_H

#include <boost/noncopyable.hpp>
#include <libwccl/variables.h>
#include <libwccl/sentencecontext.h>
#include <libwccl/ops/actionexeccontext.h>

namespace Wccl {

/**
 * Class holding execution context of a functional operator
 * i.e. state that the function should operate on.
 */
class FunExecContext : boost::noncopyable
{
public:
	FunExecContext( const SentenceContext& sentence_context,
					const boost::shared_ptr<Variables>& vars)
		: sentence_context_(sentence_context), vars_(vars)
	{
	}

	FunExecContext(const ActionExecContext& action_exec_context)
		: sentence_context_(action_exec_context.sentence_context()),
		  vars_(action_exec_context.variables())
	{
		// this is intentionally left implicit :)
	}

	/**
	 * @returns Context of a sentence the operator is applied to.
	 * @note Functional operators should not change sentence state,
	 * hence the const reference.
	 */
	const SentenceContext& sentence_context() const {
		return sentence_context_;
	}

	/**
	 * @returns Pointer to variables the operator should operate with.
	 * @note Variables should be accesible to modifications, but overall
	 * object should not get replaced, hence the const pointer.
	 */
	const boost::shared_ptr<Variables>& variables() const {
		return vars_;
	}

private:
	const SentenceContext& sentence_context_;
	const boost::shared_ptr<Variables> vars_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_FUNEXECCONTEXT_H
