#include <libwccl/ops/functions/bool/predicates/issingular.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

FunctionBase::BaseRetValPtr IsSingular::apply_internal(const FunExecContext& context) const {
	const boost::shared_ptr<const TSet>& tag = arg_expr_->apply(context);
	return Predicate::evaluate(tagset_.tag_is_singular(tag->get_value()), context);
}

std::string IsSingular::to_string(const Corpus2::Tagset &tagset) const {
	return UnaryFunctionFormatter::to_string(tagset, *this, *arg_expr_);
}

std::ostream& IsSingular::write_to(std::ostream &os) const {
	return os << this->raw_name() << "(" << *this->arg_expr_ << ")";
}

} /* end ns Wccl */
