#include <libwccl/ops/functions/bool/iterations/atleast.h>
#include <sstream>

namespace Wccl {

bool AtLeast::iterate(
	int left,
	int right,
	Wccl::Position &p,
	const Wccl::FunExecContext &context) const
{
	int left_to_match = min_matches_;
	for(int i = left; i <= right; ++i) {
		p.set_value(i);
		if(evaluating_expr_->apply(context)) {
			if(--left_to_match == 0) {
				return true;
			}
		}
	}
	return false;
}

std::string AtLeast::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ss;
	ss << name(tagset) << "("
		<< left_pos_expr_->to_string(tagset) << ", "
		<< right_pos_expr_->to_string(tagset) << ", "
		<< Position::var_repr(iter_var_acc_.get_name()) << ", "
		<< evaluating_expr_->to_string(tagset) << ", "
		<< min_matches_ << ")";
	return ss.str();
}

std::ostream& AtLeast::write_to(std::ostream& os) const
{
	return os << raw_name() << "("
			<< *left_pos_expr_ << ", "
			<< *right_pos_expr_ << ", "
			<< Position::var_repr(iter_var_acc_.get_name()) << ", "
			<< *evaluating_expr_ << ")"
			<< min_matches_ << ")";
}

} /* end ns Wccl */
