#include <libwccl/ops/functions/bool/predicates/weakagreement.h>

namespace Wccl {

std::string WeakAgreement::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ss;
	ss << name(tagset) << "("
		<< left_pos_expr_->to_string(tagset) << ", "
		<< right_pos_expr_->to_string(tagset) << ", "
		<< attribs_expr_->to_string(tagset) << ")";
	return ss.str();
}

std::ostream& WeakAgreement::write_to(std::ostream& os) const
{
	return os << raw_name() << "("
			<< *left_pos_expr_ << ", "
			<< *right_pos_expr_ << ", "
			<< *attribs_expr_ << ")";
}

WeakAgreement::BaseRetValPtr WeakAgreement::apply_internal(const FunExecContext& context) const
{
	const SentenceContext& sc = context.sentence_context();

	const boost::shared_ptr<const Position>& range_left = left_pos_expr_->apply(context);
	if (range_left->get_value() == Position::Nowhere) {
		return Predicate::False(context);
	}
	const boost::shared_ptr<const Position>& range_right = right_pos_expr_->apply(context);
	if (range_right->get_value() == Position::Nowhere) {
		return Predicate::False(context);
	}
	// Get absolute values for left and right extremes of the range.
	int abs_left = sc.get_abs_position(*range_left);
	int abs_right = sc.get_abs_position(*range_right);
	// Trim range to sentence boundaries
	if (abs_left < 0) {
		abs_left = 0;
	}
	if (abs_right >= sc.size()) {
		abs_right = sc.size() - 1;
	}
	// Proceed only if range isn't empty (range outside of sentence or empty sentence are covered)
	if (abs_left > abs_right) {
		return Predicate::False(context);
	}

	const boost::shared_ptr<const TSet>& attribs_tset = attribs_expr_->apply(context);
	const Corpus2::Tag& attribs = attribs_tset->get_value();

	//
	// @todo: implement
	//

	return Predicate::False(context);
}

} /* end ns Wccl */
