#include <libwccl/ops/functions/bool/predicates/pointagreement.h>

namespace Wccl {

std::string PointAgreement::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ss;
	ss << name(tagset) << "("
		<< pos1_expr_->to_string(tagset) << ", "
		<< pos2_expr_->to_string(tagset) << ", "
		<< attribs_expr_->to_string(tagset) << ")";
	return ss.str();
}

std::ostream& PointAgreement::write_to(std::ostream& os) const
{
	return os << raw_name() << "("
			<< *pos1_expr_ << ", "
			<< *pos2_expr_ << ", "
			<< *attribs_expr_ << ")";
}

PointAgreement::BaseRetValPtr PointAgreement::apply_internal(const FunExecContext& context) const
{
	const SentenceContext& sc = context.sentence_context();

	const boost::shared_ptr<const Position>& pos1 = pos1_expr_->apply(context);
	if (pos1->is_outside(sc)) {
		return Predicate::False(context);
	}
	const boost::shared_ptr<const Position>& pos2 = pos2_expr_->apply(context);
	if (pos2->is_outside(sc)) {
		return Predicate::False(context);
	}

	const boost::shared_ptr<const TSet>& attribs_tset = attribs_expr_->apply(context);
	const Corpus2::Tag& attribs = attribs_tset->get_value();

	//
	// @todo: implement
	//

	return Predicate::False(context);
}

} /* end ns Wccl */
