#include <libwccl/ops/functions/bool/predicates/isinside.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

IsInside::BaseRetValPtr IsInside::apply_internal(const FunExecContext& context) const
{
	const boost::shared_ptr<const Position>& pos = pos_expr_->apply(context);
	return Predicate::evaluate(pos->is_inside(context.sentence_context()), context);
}

std::string IsInside::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *pos_expr_);
}

std::ostream& IsInside::write_to(std::ostream& os) const
{
	return os << raw_name() << "(" << *pos_expr_ << ")";
}

} /* end ns Wccl */
