#include <libwccl/ops/opsequence.h>

namespace Wccl {

FunctionalOpSequence::name_op_v_t& FunctionalOpSequence::add_name_op_pairs_untyped(
	name_op_v_t& pairs)
{
	for(size_t i = 0; i < size(); ++i) {
		pairs.push_back(gen_name_op_pair_untyped(i));
	}
	return pairs;
}

FunctionalOpSequence::name_op_v_c_t& FunctionalOpSequence::add_name_op_pairs_untyped(
	name_op_v_c_t& pairs) const
{
	for(size_t i = 0; i < size(); ++i) {
		pairs.push_back(gen_name_op_pair_untyped(i));
	}
	return pairs;
}

std::string UntypedOpSequence::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream os;
	os << "@" << name() << " (";
	for (size_t i = 0; i < size(); ++i) {
		if (i != 0) {
			os << ", ";
		}
		os << ops_[i]->to_string(tagset);
	}
	os << ")";
	return os.str();
}

std::ostream& UntypedOpSequence::write_to(std::ostream& os) const
{
	os << "@" << name() << " (";
	for (size_t i = 0; i < size(); ++i) {
		if (i != 0) {
			os << ", ";
		}
		os << *ops_[i];
	}
	return os << ")";
}

UntypedOpSequence::UntypedOpSequence(const UntypedOpSequence& seq)
	: FunctionalOpSequence(seq.name_),
	  ops_(seq.size())
{
	foreach(const fun_op_ptr_t& op, seq.ops_) {
		ops_.push_back(op->clone_ptr());
	}
}

} /* end ns Wccl */
