#ifndef LIBWCCL_OPS_MATCH_MATCHACTION_H
#define LIBWCCL_OPS_MATCH_MATCHACTION_H

#include <libwccl/ops/expression.h>
#include <libwccl/ops/actionexeccontext.h>

namespace Wccl {

/**
 * Abstract base class for actions in WCCL match rules
 */
class MatchAction : public Expression
{
public:
	/**
	 * @returns Name of the action.
	 */
	virtual std::string name() const = 0;
	/**
	 * Executes the action for the given execution context.
	 */
	virtual void execute(const ActionExecContext& context) const = 0;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_MATCHACTION_H
