#include <libwccl/ops/functions/strset/lextranslator.h>
#include <sstream>

namespace Wccl {

std::string LexTranslator::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream os;
	os << name(tagset) << "(" 
		<< strset_expr_->to_string(tagset) << ", \""
		<< lexicon_->name() << "\")";
	return os.str();
}

std::ostream& LexTranslator::write_to(std::ostream& os) const
{
	os << raw_name() << "(" << *strset_expr_ << ", \"" << lexicon_->name() << "\")";
	return os;
}

LexTranslator::BaseRetValPtr LexTranslator::apply_internal(
	const FunExecContext& context) const
{
	boost::shared_ptr<const StrSet> set = strset_expr_->apply(context);
	return lexicon_->translate(*set);
}

} /* end ns Wccl */
