#ifndef LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_OR_H
#define LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_OR_H

#include <libwccl/ops/functions/bool/predicates/logicalpredicate.h>

namespace Wccl {

/**
 * Operator that realises logical predicate "or"
 */
class Or : public LogicalPredicate
{
public:
	Or(const boost::shared_ptr<BoolFunctionPtrVector>& expressions)
		: LogicalPredicate(expressions)
	{
	}

	/**
	 * @returns Name of the function: "or"
	 */
	std::string raw_name() const {
		return "or";
	}
protected :
	/**
	 * "Or" predicate evaluates expressions one by one in order from left to right,
	 * and True is returned once an expression evaluating to True is found.
	 * If all of the expressions were False, False is returned.
	 */
	BaseRetValPtr apply_internal(const FunExecContext&) const;

};

} /* end ns Wccl */
#endif // LIBWCCL_OPS_FUNCTIONS_BOOL_PREDICATES_OR_H
