#include <libwccl/ops/functions/bool/predicates/logicalpredicate.h>

namespace Wccl {

std::string LogicalPredicate::to_string(const Corpus2::Tagset& tagset) const
{
	std::stringstream ss;
	ss << name(tagset) << "(";
	BoolFunctionPtrVector::const_iterator it = expressions_->begin();
	while(it != expressions_->end()) {
		ss << (*it)->to_string(tagset);
		if(++it != expressions_->end()) {
			ss << ", ";
		}
	}
	ss << ")";
	return ss.str();
}

std::ostream& LogicalPredicate::write_to(std::ostream& ostream) const
{
	ostream << raw_name() << "(";
	BoolFunctionPtrVector::const_iterator it = expressions_->begin();
	while(it != expressions_->end()) {
		ostream << (*it)->to_raw_string();
		if(++it != expressions_->end()) {
			ostream << ", ";
		}
	}
	ostream << ")";
	return ostream;
}

} /* end ns Wccl */
